unit _ulamek;

interface

uses SysUtils;

type
Ulamek = class
    private
        licznik :Integer;
        mianownik :Integer;
    public
        constructor Create(const alicznik :Integer =0; const amianownik :Integer =1);
        procedure SetValues(const alicznik, amianownik :Integer);
        procedure GetValues(var rlicznik :Integer; var rmianownik :Integer); overload;
        procedure GetValues(plicznik, pmianownik :PInteger); overload;
        function ToFloat :Extended;
        function ToString :String;
    end;

function IntToUlamek(const liczba :Integer) :Ulamek;
function UlamekProd(const AUlamek1, AUlamek2 :Ulamek) :Ulamek;
function UlamekQuot(const AUlamek1, AUlamek2 :Ulamek) :Ulamek;
function UlamekSum(const AUlamek1, AUlamek2 :Ulamek) :Ulamek;
function UlamekRevr(const AUlamek1 :Ulamek) :Ulamek;
function UlamekDiff(const AUlamek1, AUlamek2 :Ulamek) :Ulamek;
function UlamekCmp(const AUlamek1, AUlamek2 :Ulamek) :Integer;
function UlamekToFloat(const AUlamek :Ulamek) :Extended;
function UlamekToStr(const AUlamek :Ulamek) :String;

implementation

constructor Ulamek.Create(const alicznik :Integer =0; const amianownik :Integer =1);
begin
inherited Create; //TObject.Create()
SetValues(alicznik,amianownik);
end;

procedure Ulamek.SetValues(const alicznik, amianownik :Integer);
begin
if amianownik=0 then raise Exception.Create('Ulamek: Blad #1');
licznik:=alicznik;
mianownik:=amianownik;
end;

procedure Ulamek.GetValues(var rlicznik :Integer; var rmianownik :Integer);
begin
rlicznik:=licznik;
rmianownik:=mianownik;
end;

procedure Ulamek.GetValues(plicznik :PInteger; pmianownik :PInteger);
begin
plicznik^:=licznik;
pmianownik^:=mianownik;
end;

function Ulamek.ToFloat :Extended;
begin
ToFloat:=licznik/mianownik;
end;

function Ulamek.ToString :String;
begin
ToString:=IntToStr(licznik)+'/'+IntToStr(mianownik);
end;


{ FUNKCJA KONWERTUJACA }

function IntToUlamek(const liczba :Integer) :Ulamek;
begin
IntToUlamek:=Ulamek.Create(liczba,1);
end;

function UlamekToFloat(const AUlamek :Ulamek) :Extended;
begin
UlamekToFloat:=AUlamek.ToFloat;
end;

function UlamekToStr(const AUlamek :Ulamek) :String;
begin
UlamekToStr:=AUlamek.ToString;
end;


{OPERACJE NA ULAMKACH }
{iloczyn}
function UlamekProd(const AUlamek1, AUlamek2 :Ulamek) :Ulamek;
var alicznik1,amianownik1,alicznik2,amianownik2 :Integer;
begin
AUlamek1.GetValues(alicznik1,amianownik1);
AUlamek2.GetValues(alicznik2,amianownik2);
UlamekProd:=Ulamek.Create(alicznik1*alicznik2,amianownik1*amianownik2);
end;

{iloraz}
function UlamekQuot(const AUlamek1, AUlamek2 :Ulamek) :Ulamek;
var alicznik1,amianownik1,alicznik2,amianownik2 :Integer;
begin
AUlamek1.GetValues(alicznik1,amianownik1);
AUlamek2.GetValues(alicznik2,amianownik2);
UlamekQuot:=Ulamek.Create(alicznik1*amianownik2,amianownik1*alicznik2);
end;

{suma}
function UlamekSum(const AUlamek1, AUlamek2 :Ulamek) :Ulamek;
var alicznik1,amianownik1,alicznik2,amianownik2 :Integer;
begin
AUlamek1.GetValues(alicznik1,amianownik1);
AUlamek2.GetValues(alicznik2,amianownik2);
UlamekSum:=Ulamek.Create(alicznik1*amianownik2+alicznik2*amianownik1,amianownik1*amianownik2);
end;

{zmiana znaku}
function UlamekRevr(const AUlamek1 :Ulamek) :Ulamek;
var alicznik1,amianownik1 :Integer;
begin
AUlamek1.GetValues(alicznik1,amianownik1);
UlamekRevr:=Ulamek.Create(-alicznik1,amianownik1);
end;

{roznica}
function UlamekDiff(const AUlamek1, AUlamek2 :Ulamek) :Ulamek;
var alicznik1,amianownik1,alicznik2,amianownik2 :Integer;
begin
AUlamek1.GetValues(alicznik1,amianownik1);
AUlamek2.GetValues(alicznik2,amianownik2);
UlamekDiff:=Ulamek.Create(alicznik1*amianownik2-alicznik2*amianownik1,amianownik1*amianownik2);
end;

{porownanie <, >, =}
function UlamekCmp(const AUlamek1, AUlamek2 :Ulamek) :Integer;
var alicznik1,amianownik1,alicznik2,amianownik2 :Integer;
    wynik :Double;
    int_wynik :Integer;
begin
AUlamek1.GetValues(alicznik1,amianownik1);
AUlamek2.GetValues(alicznik2,amianownik2);
wynik:=(alicznik1/amianownik1)-(alicznik1/amianownik2);
if wynik=0 then int_wynik:=Round(wynik) else int_wynik:=Round(wynik/abs(wynik));
UlamekCmp:=int_wynik;
end;

end.
